<?php
/**
 * Project: MinervaKB.
 * Copyright: 2015-2017 @KonstruktStudio
 */

class MinervaKB_FeatureRequestSubmitShortcode extends KST_Shortcode implements KST_Shortcode_Interface {

	protected $ID = 'feature-request-submit';
	protected $name = 'Feature Request Submit';
	protected $description = 'Feature Requests submit form';
	protected $icon = 'fa fa-thumbs-o-up';

	public function render($atts, $content = '') {
        if (MKB_Options::option('feature_request_submit_disable')) {
            $disabled_message = MKB_Options::option('feature_request_submit_disable_message');

            if ($disabled_message) {
                echo do_shortcode('[mkb-info]' . $disabled_message . '[/mkb-info]');
            }

            return;
        }

        MKB_FormsBuilder::render_form(MKB_FormsBuilder::get_form_config('featureRequestSubmitForm'));
	}
}